#include <vcl.h>
#pragma hdrstop

#include <registry.hpp>

#include <memory>
using namespace std;

#include "Main.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   MainMemo->Lines->Add("Owner/User Information:");
   MainMemo->Lines->Add("");

   GetRegisteredOwner(MainMemo->Lines);

   MainMemo->Lines->Add("");

   GetNetworkInfo(MainMemo->Lines);
   }

void __fastcall TMainForm::GetNetworkInfo(TStrings *lines)
   {
   char buf[300];
   DWORD bufSize = sizeof(buf);

   bool success = ::GetUserName(buf, &bufSize);
   if (success)
      lines->Add("Network user name = " + String(buf));
   else
      lines->Add("Unable to get network user name.");

   bufSize = sizeof(buf);
   success = ::GetComputerName(buf, &bufSize);
   if (success)
      lines->Add("Network computer name = " + String(buf));
   else
      lines->Add("Unable to get network computer name.");
   }

static char *MS1_NT   = "\\Software\\Microsoft\\Windows NT\\CurrentVersion";
static char *MS1_9X   = "\\Software\\Microsoft\\Windows\\CurrentVersion";
static char *MS1_NAME = "RegisteredOwner";
static char *MS1_ORG  = "RegisteredOrganization";

static char *MS2      = "\\Software\\Microsoft\\MS Setup (ACME)\\User Info";
static char *MS2_NAME = "DefName";
static char *MS2_ORG  = "DefCompany";


void __fastcall TMainForm::GetRegisteredOwner(TStrings *lines)
   {
   try
      {
      auto_ptr<TRegistry> registry(new TRegistry);
      registry->RootKey = HKEY_LOCAL_MACHINE;

      String key = (Win32Platform == VER_PLATFORM_WIN32_NT) ? MS1_NT : MS1_9X;
      if (registry->OpenKey(key, false))
         {
         String name, org;
         lines->Add("Checking HKEY_LOCAL_MACHINE" + key);

         if (registry->ValueExists(MS1_NAME))
            name = registry->ReadString(MS1_NAME);
         if (registry->ValueExists(MS1_ORG))
            org = registry->ReadString(MS1_ORG);

         lines->Add(String(MS1_NAME) + " = " + name);
         lines->Add(String(MS1_ORG) + " = " + org);
         }
      else
         lines->Add("Unable to open HKEY_LOCAL_MACHINE" + key);

      lines->Add("");

      if (registry->OpenKey(MS2, false))
         {
         String name, org;
         lines->Add("Checking HKEY_LOCAL_MACHINE" + String(MS2));

         if (registry->ValueExists(MS2_NAME))
            name = registry->ReadString(MS2_NAME);
         if (registry->ValueExists(MS2_ORG))
            org = registry->ReadString(MS2_ORG);

         lines->Add(String(MS2_NAME) + " = " + name);
         lines->Add(String(MS2_ORG) + " = " + org);
         }
      else
         lines->Add("Unable to open HKEY_LOCAL_MACHINE" + String(MS2));
      }

   catch (...)
      {
      lines->Add("Stopped by an exception.");
      throw;
      }
   }

void __fastcall TMainForm::OKBtnClick(TObject *Sender)
   {
   Close();
   }




